/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.util;

import com.mojang.datafixers.util.Either;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderOwner;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import org.jetbrains.annotations.Nullable;

public class FullReferenceHolder<T>
implements Holder<T> {
    private Set<TagKey<T>> tags = Set.of();
    @Nullable
    private ResourceKey<T> key;
    @Nullable
    private T value;
    private ResourceKey<Registry<T>> owner;

    private FullReferenceHolder(ResourceKey<Registry<T>> owner, @Nullable ResourceKey<T> resourceKey, @Nullable T object) {
        this.owner = owner;
        this.key = resourceKey;
        this.value = object;
    }

    public static <T> FullReferenceHolder<T> create(ResourceKey<Registry<T>> owner, ResourceKey<T> resourceKey, @Nullable T object) {
        return new FullReferenceHolder<T>(owner, resourceKey, object);
    }

    public static <T> FullReferenceHolder<T> create(ResourceKey<Registry<T>> owner, ResourceLocation id, @Nullable T object) {
        return new FullReferenceHolder<T>(owner, ResourceKey.m_135785_(owner, (ResourceLocation)id), object);
    }

    public ResourceKey<T> key() {
        if (this.key == null) {
            throw new IllegalStateException("Trying to access unbound value '" + this.value + "' from registry " + this.owner);
        }
        return this.key;
    }

    public T m_203334_() {
        if (this.value == null) {
            throw new IllegalStateException("Trying to access unbound value '" + this.key + "' from registry " + this.owner);
        }
        return this.value;
    }

    public boolean m_203373_(ResourceLocation resourceLocation) {
        return this.key().m_135782_().equals((Object)resourceLocation);
    }

    public boolean m_203565_(ResourceKey<T> resourceKey) {
        return this.key() == resourceKey;
    }

    public boolean m_203656_(TagKey<T> tagKey) {
        return this.tags.contains(tagKey);
    }

    public Stream<TagKey<T>> m_203616_() {
        return this.tags.stream();
    }

    public boolean m_203425_(Predicate<ResourceKey<T>> predicate) {
        return predicate.test(this.key());
    }

    public boolean m_203401_(HolderOwner<T> holderOwner) {
        return true;
    }

    public Either<ResourceKey<T>, T> m_203439_() {
        return Either.left(this.key());
    }

    public Optional<ResourceKey<T>> m_203543_() {
        return Optional.of(this.key());
    }

    public Holder.Kind m_203376_() {
        return Holder.Kind.REFERENCE;
    }

    public boolean m_203633_() {
        return this.key != null && this.value != null;
    }

    public String toString() {
        return "FullReference{" + this.key + "=" + this.value + "}";
    }
}

